from flask import Flask, render_template, request, redirect, flash, Response
from utils.auth import get_access_token
from utils.query import query_bo_register, flatten_bo_data
import os
import pandas as pd
import io
import json

app = Flask(__name__)
app.secret_key = os.urandom(24)

@app.route("/", methods=["GET", "POST"])
def index():
    result_data = None
    if request.method == "POST":
        mode = request.form.get("mode")
        token = get_access_token()

        if not token:
            flash("Klarte ikke å slå opp i registeret. Dette skyldes antakeligvis feil i config.env-filen eller private_key.pem-filen. Ta en ekstra titt på disse og se om du har fulgt tutorial riktig.", "danger")
            return render_template("index.html")

        elif mode == "single":
            # Accept multiple org numbers, only comma-separated
            org_numbers_input = request.form["org_number"]
            # Split on commas, strip spaces inside and outside
            raw_orgs = [org.replace(" ", "").strip() for org in org_numbers_input.split(",") if org.strip()]

            seen = set()
            org_numbers = []
            duplicates = []
            for org in raw_orgs:
                if org in seen:
                    duplicates.append(org)
                else:
                    seen.add(org)
                    org_numbers.append(org)
            all_rows = []
            errors = []
            no_data_orgs = []
            for org in org_numbers:
                try:
                    data = query_bo_register(org, token)
                    print(data)
                    if data:
                        all_rows.extend(flatten_bo_data(data))
                    else:
                        no_data_orgs.append(org)
                except Exception as e:
                    errors.append((org, str(e)))
            if all_rows:
                result_data = all_rows
            if no_data_orgs:
                flash(f"Følgende hadde ingen treff i registeret: {', '.join(no_data_orgs)}", "danger")
            for org, err in errors:
                flash(f"Error looking up {org}: {err}", "danger")
            if duplicates:
                # Show unique duplicate values in order
                dup_unique = list(dict.fromkeys(duplicates))
                flash(f"Fant dupliserte orgnummer: {', '.join(dup_unique)}", "info")

        elif mode == "export_csv":
            # Read the results posted back from the page as JSON
            result_json = request.form.get("result_json")
            if result_json:
                try:
                    data = json.loads(result_json)
                    if not data:
                        flash("No data to export.", "danger")
                    else:
                        df = pd.DataFrame(data)
                        csv_bytes = df.to_csv(index=False).encode("utf-8")
                        return Response(
                            csv_bytes,
                            mimetype="text/csv",
                            headers={"Content-Disposition": "attachment; filename=export.csv"}
                        )
                except Exception as e:
                    flash(f"Failed to generate CSV: {e}", "danger")
            else:
                flash("Ingen data å eksportere.", "danger")

    return render_template("index.html", result=result_data)

if __name__ == "__main__":
    app.run(port=5000)