@echo off
setlocal enabledelayedexpansion

REM Always run from this script's folder
cd /d "%~dp0src"

REM Find python
where python >nul 2>&1
if %errorlevel% neq 0 (
  powershell -Command "Add-Type -AssemblyName PresentationFramework; [System.Windows.MessageBox]::Show('Python not found. Please install Python 3 from python.org or via Microsoft Store.', 'Error')"
  exit /b 1
)

set PY=python

REM Create venv if missing
if not exist ".venv\Scripts\python.exe" (
  %PY% -m venv .venv
)

set PYEXE=.venv\Scripts\python.exe

REM Upgrade pip and install deps
%PYEXE% -m pip install --upgrade pip >nul

if exist requirements.txt (
  %PYEXE% -m pip install -r requirements.txt
) else (
  %PYEXE% -m pip install flask requests python-dotenv pandas
)

REM Run the app (browser opens from run_server.py)
%PYEXE% run_server.py